﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reactive.Concurrency;
using System.Reactive.Linq;
using System.Text;
using System.Threading.Tasks;

namespace BasicRx
{
    class Examples13_15
    {
        public static void GenerateItems()
        {
            // Listing 11-13
            IObservable<int> src = Observable.Generate(
                new { Current = 0, Total = 3, Random = new Random() },
                state => state.Total <= 10000,
                state =>
                {
                    int value = state.Random.Next(1000);
                    return new { Current = value, Total = state.Total + value, state.Random };
                },
                state => state.Current);


            src.Subscribe(i => Console.Write(i + " "));
            Console.WriteLine();
        }

        public static void GenerateItemsWithDelayIndefinite()
        {
            // Listing 11-14
            IObservable<int> src = Observable.Generate(
                new { Current = 0, Total = 3, Random = new Random() },
                state => state.Total < 10000,
                state =>
                {
                    int value = state.Random.Next(1000);
                    return new { Current = value, Total = state.Total + value, state.Random };
                },
                state => state.Current,
                state => TimeSpan.FromMilliseconds(state.Random.Next(1000)));


            // Listing 11-15
            src.Subscribe(x => Console.WriteLine(x));
            while (true)
            {
                Scheduler.Default.Yield();
            }
        }
    }
}
